<?php
/*
 * LaraClassifier - Classified Ads Web Application
 * Copyright (c) BeDigit. All Rights Reserved
 *
 * Website: https://laraclassifier.com
 * Author: Mayeul Akpovi (BeDigit - https://bedigit.com)
 *
 * LICENSE
 * -------
 * This software is provided under a license agreement and may only be used or copied
 * in accordance with its terms, including the inclusion of the above copyright notice.
 * As this software is sold exclusively on CodeCanyon,
 * please review the full license details here: https://codecanyon.net/licenses/standard
 */

namespace App\Http\Controllers\Api;

use App\Http\Requests\Front\ContactRequest;
use App\Http\Requests\Front\ReportRequest;
use App\Services\ContactService;
use Illuminate\Http\JsonResponse;

/**
 * @group Contact
 */
class ContactController extends BaseController
{
	protected ContactService $contactService;
	
	/**
	 * @param \App\Services\ContactService $contactService
	 */
	public function __construct(ContactService $contactService)
	{
		parent::__construct();
		
		$this->contactService = $contactService;
	}
	
	/**
	 * Send Form
	 *
	 * Send a message to the site owner.
	 *
	 * @bodyParam country_code string required The user's country code. Example: US
	 * @bodyParam country_name string required The user's country name. Example: United Sates
	 * @bodyParam first_name string required The user's first name. Example: John
	 * @bodyParam last_name string required The user's last name. Example: Doe
	 * @bodyParam email string required The user's email address. Example: john.doe@domain.tld
	 * @bodyParam message string required The message to send. Example: Nesciunt porro possimus maiores voluptatibus accusamus velit qui aspernatur.
	 * @bodyParam captcha_key string Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel).
	 *
	 * @param \App\Http\Requests\Front\ContactRequest $request
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function sendForm(ContactRequest $request): JsonResponse
	{
		return $this->contactService->submitContactForm($request);
	}
	
	/**
	 * Report post
	 *
	 * Report abuse or issues
	 *
	 * @bodyParam report_type_id int required The report type ID. Example: 2
	 * @bodyParam email string required The user's email address. Example: john.doe@domain.tld
	 * @bodyParam message string required The message to send. Example: Et sunt voluptatibus ducimus id assumenda sint.
	 * @bodyParam captcha_key string Key generated by the CAPTCHA endpoint calling (Required when the CAPTCHA verification is enabled from the Admin panel).
	 *
	 * @urlParam id int required The post ID.
	 *
	 * @param $postId
	 * @param ReportRequest $request
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function sendReport($postId, ReportRequest $request): JsonResponse
	{
		return $this->contactService->submitReportForm($postId, $request);
	}
}
