<?php
/*
 * LaraClassifier - Classified Ads Web Application
 * Copyright (c) BeDigit. All Rights Reserved
 *
 * Website: https://laraclassifier.com
 * Author: Mayeul Akpovi (BeDigit - https://bedigit.com)
 *
 * LICENSE
 * -------
 * This software is provided under a license agreement and may only be used or copied
 * in accordance with its terms, including the inclusion of the above copyright notice.
 * As this software is sold exclusively on CodeCanyon,
 * please review the full license details here: https://codecanyon.net/licenses/standard
 */

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BaseResource extends JsonResource
{
	protected array $params;
	protected array $embed;
	
	/**
	 * @param $resource
	 * @param array $params
	 */
	public function __construct($resource, array $params = [])
	{
		parent::__construct($resource);
		
		$this->params = $params;
		$this->embed = getCommaSeparatedStrAsArray($params['embed'] ?? []);
	}
}
