<?php
/*
 * LaraClassifier - Classified Ads Web Application
 * Copyright (c) BeDigit. All Rights Reserved
 *
 * Website: https://laraclassifier.com
 * Author: Mayeul Akpovi (BeDigit - https://bedigit.com)
 *
 * LICENSE
 * -------
 * This software is provided under a license agreement and may only be used or copied
 * in accordance with its terms, including the inclusion of the above copyright notice.
 * As this software is sold exclusively on CodeCanyon,
 * please review the full license details here: https://codecanyon.net/licenses/standard
 */

namespace App\Services\Auth\Traits\System;

use App\Services\Auth\Traits\System\AuthenticatesUsers\ThrottlesLogins;
use Illuminate\Http\Request;

trait AuthenticatesUsers
{
	use ThrottlesLogins;
	
	/**
	 * Get the needed authorization credentials from the request
	 *
	 * @param \Illuminate\Http\Request $request
	 * @return array
	 */
	protected function credentials(Request $request)
	{
		return $request->only($this->username(), 'password');
	}
	
	/**
	 * Get the login username to be used by the controller
	 *
	 * @return string
	 */
	public function username()
	{
		return 'email';
	}
}
