<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CategorySeeder extends Seeder
{
	/**
	 * Run the database seeds.
	 *
	 * @return void
	 */
	public function run()
	{
		$entries = [
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Automobiles',
					'fr' => 'Auto & Moto',
					'es' => 'Automóviles',
					'ar' => 'السيارات',
					'pt' => 'Automóveis',
					'ru' => 'Автомобили',
					'tr' => 'Otomobil',
					'th' => 'รถยนต์',
					'ka' => 'ავტომობილები',
					'zh' => '汽车类',
					'ja' => '自動車',
					'it' => 'Automobili',
					'ro' => 'Automobile',
					'de' => 'Automobile und Fahrzeuge',
					'hi' => 'ऑटोमोबाइल',
					'bn' => 'অটোমোবাইল',
					'he' => 'מכוניות',
				],
				'slug'             => 'automobiles',
				'description'      => null,
				'image_path'       => 'app/categories/blue/car.png',
				'icon_class'       => 'fa-solid fa-car',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Cars',
						],
						'slug'             => 'cars',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Buses & Minibus',
						],
						'slug'             => 'buses-and-minibus',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Heavy Equipment',
						],
						'slug'             => 'heavy-equipment',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Motorcycles & Scooters',
						],
						'slug'             => 'motorcycles-and-scooters',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Trucks & Trailers',
						],
						'slug'             => 'trucks-and-trailers',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Vehicle Parts & Accessories',
						],
						'slug'             => 'car-parts-and-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Watercraft & Boats',
						],
						'slug'             => 'watercraft-and-boats',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Phones & Tablets',
					'fr' => 'Smartphone & Tablettes',
					'es' => 'Smartphone y Tabletas',
					'ar' => 'الهواتف والأجهزة اللوحية',
					'pt' => 'Telemóveis e Tablets',
					'ru' => 'Телефоны и планшеты',
					'tr' => 'Telefonlar ve Tabletler',
					'th' => 'โทรศัพท์และแท็บเล็ต',
					'ka' => 'ტელეფონები და ტაბლეტები',
					'zh' => '手机和平板电脑',
					'ja' => '携帯電話とタブレット',
					'it' => 'Telefoni e tablet',
					'ro' => 'Telefoane și tablete',
					'de' => 'Telefone & Tablets',
					'hi' => 'फ़ोन और टेबलेट',
					'bn' => 'ফোন এবং ট্যাবলেট',
					'he' => 'טלפונים וטאבלטים',
				],
				'slug'             => 'phones-and-tablets',
				'description'      => null,
				'image_path'       => 'app/categories/blue/mobile-alt.png',
				'icon_class'       => 'fa-solid fa-mobile-screen-button',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Mobile Phones',
						],
						'slug'             => 'mobile-phones',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Accessories for Mobile Phones & Tablets',
						],
						'slug'             => 'mobile-phones-tablets-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Smart Watches & Trackers',
						],
						'slug'             => 'smart-watches-and-trackers',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Tablets',
						],
						'slug'             => 'tablets',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Electronics',
					'fr' => 'Hi-Tech',
					'es' => 'Electrónica',
					'ar' => 'إلكترونيات',
					'pt' => 'Eletrônicos',
					'ru' => 'Электроника',
					'tr' => 'Elektronik',
					'th' => 'อิเล็กทรอนิกส์',
					'ka' => 'ელექტრონიკა',
					'zh' => '电子产品',
					'ja' => 'エレクトロニクス',
					'it' => 'Elettronica',
					'ro' => 'Electronică',
					'de' => 'Elektronik',
					'hi' => 'इलेक्ट्रानिक्स',
					'bn' => 'ইলেকট্রনিক্স',
					'he' => 'מכשירי חשמל',
				],
				'slug'             => 'electronics',
				'description'      => null,
				'image_path'       => 'app/categories/blue/fa-laptop.png',
				'icon_class'       => 'fa-solid fa-laptop',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Accessories & Supplies for Electronics',
						],
						'slug'             => 'accessories-supplies-for-electronics',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Laptops & Computers',
						],
						'slug'             => 'laptops-and-computers',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'TV & DVD Equipment',
						],
						'slug'             => 'tv-dvd-equipment',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Audio & Music Equipment',
						],
						'slug'             => 'audio-music-equipment',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Computer Accessories',
						],
						'slug'             => 'computer-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Computer Hardware',
						],
						'slug'             => 'computer-hardware',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Computer Monitors',
						],
						'slug'             => 'computer-monitors',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Headphones',
						],
						'slug'             => 'headphones',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Networking Products',
						],
						'slug'             => 'networking-products',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Photo & Video Cameras',
						],
						'slug'             => 'photo-video-cameras',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Printers & Scanners',
						],
						'slug'             => 'printers-and-scanners',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Security & Surveillance',
						],
						'slug'             => 'security-and-surveillance',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Software',
						],
						'slug'             => 'software',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Video Games',
						],
						'slug'             => 'video-games',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Game Consoles',
						],
						'slug'             => 'video-game-consoles',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Furniture & Appliances',
					'fr' => 'Meubles & Electroménagers',
					'es' => 'Muebles y Electrodomésticos',
					'ar' => 'الأثاث والأجهزة',
					'pt' => 'Móveis e Eletrodomésticos',
					'ru' => 'Мебель и техника',
					'tr' => 'Mobilya ve Ev Aletleri',
					'th' => 'เฟอร์นิเจอร์และเครื่องใช้ไฟฟ้า',
					'ka' => 'ავეჯი და ტექნიკა',
					'zh' => '家居，家具和电器',
					'ja' => '家庭、家具、電化製品',
					'it' => 'Mobili ed elettrodomestici',
					'ro' => 'Mobilier și electrocasnice',
					'de' => 'Möbel & Geräte',
					'hi' => 'फर्नीचर और उपकरण',
					'bn' => 'আসবাবপত্র ও যন্ত্রপাতি',
					'he' => 'ריהוט ומוצרי חשמל',
				],
				'slug'             => 'furniture-appliances',
				'description'      => null,
				'image_path'       => 'app/categories/blue/couch.png',
				'icon_class'       => 'fa-solid fa-couch',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Furniture - Tableware',
						],
						'slug'             => 'furniture-tableware',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Antiques - Art - Decoration',
						],
						'slug'             => 'antiques-art-decoration',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Appliances',
						],
						'slug'             => 'appliances',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Garden',
						],
						'slug'             => 'garden',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Toys - Games - Figurines',
						],
						'slug'             => 'toys-games-figurines',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Wine & Gourmet - Recipes',
						],
						'slug'             => 'wine-gourmet-recipes',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Real estate',
					'fr' => 'Immobilier',
					'es' => 'Bienes raíces',
					'ar' => 'العقارات',
					'pt' => 'Imobiliária',
					'ru' => 'Недвижимость',
					'tr' => 'Emlak',
					'th' => 'อสังหาริมทรัพย์',
					'ka' => 'Უძრავი ქონება',
					'zh' => '房地产',
					'ja' => '不動産',
					'it' => 'Immobiliare',
					'ro' => 'Proprietate imobiliara',
					'de' => 'Grundeigentum',
					'hi' => 'रियल एस्टेट',
					'bn' => 'আবাসন',
					'he' => 'נדל"ן',
				],
				'slug'             => 'real-estate',
				'description'      => null,
				'image_path'       => 'app/categories/blue/fa-home.png',
				'icon_class'       => 'fa-solid fa-house',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Houses & Apartments For Rent',
						],
						'slug'             => 'houses-apartments-for-rent',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Houses & Apartments For Sale',
						],
						'slug'             => 'houses-apartments-for-sale',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Land & Plots for Rent',
						],
						'slug'             => 'land-and-plots-for-rent',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Land & Plots For Sale',
						],
						'slug'             => 'land-and-plots-for-sale',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Commercial Property For Rent',
						],
						'slug'             => 'commercial-property-for-rent',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Commercial Property For Sale',
						],
						'slug'             => 'commercial-properties',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Event centres, Venues and Workstations',
						],
						'slug'             => 'event-centers-and-venues',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Short Rental',
						],
						'slug'             => 'temporary-and-vacation-rentals',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Animals & Pets',
					'fr' => 'Animaux',
					'es' => 'Animales y Mascotas',
					'ar' => 'الحيوانات',
					'pt' => 'Animais e Mascotes',
					'ru' => 'Животные',
					'tr' => 'Hayvanlar',
					'th' => 'สัตว์และสัตว์เลี้ยง',
					'ka' => 'ცხოველები',
					'zh' => '动物与宠物',
					'ja' => '動物とペット',
					'it' => 'Animali',
					'ro' => 'Animale',
					'de' => 'Tiere & Haustiere',
					'hi' => 'पशु और पालतू जानवर',
					'bn' => 'প্রাণী এবং পোষা প্রাণী',
					'he' => 'בעלי חיים וחיות מחמד',
				],
				'slug'             => 'animals-and-pets',
				'description'      => null,
				'image_path'       => 'app/categories/blue/paw.png',
				'icon_class'       => 'fa-solid fa-paw',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Birds',
						],
						'slug'             => 'birds',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Cats & Kittens',
						],
						'slug'             => 'cats-and-kittens',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Dogs',
						],
						'slug'             => 'dogs-and-puppies',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Fish',
						],
						'slug'             => 'fish',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Pet\'s Accessories',
						],
						'slug'             => 'pets-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Reptiles',
						],
						'slug'             => 'reptiles',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Other Animals',
						],
						'slug'             => 'other-animals',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Fashion',
					'fr' => 'Mode',
					'es' => 'Moda',
					'ar' => 'موضه',
					'pt' => 'Moda',
					'ru' => 'Мода',
					'tr' => 'Moda',
					'th' => 'แฟชั่น',
					'ka' => 'მოდა',
					'zh' => '时尚',
					'ja' => 'ファッション',
					'it' => 'Moda',
					'ro' => 'Modă',
					'de' => 'Mode',
					'hi' => 'पहनावा',
					'bn' => 'ফ্যাশন',
					'he' => 'אופנה',
				],
				'slug'             => 'fashion',
				'description'      => null,
				'image_path'       => 'app/categories/blue/tshirt.png',
				'icon_class'       => 'fa-solid fa-shirt',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Bags',
						],
						'slug'             => 'bags',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Clothing',
						],
						'slug'             => 'clothing',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Clothing Accessories',
						],
						'slug'             => 'clothing-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Jewelry',
						],
						'slug'             => 'jewelry',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Shoes',
						],
						'slug'             => 'shoes',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Watches',
						],
						'slug'             => 'watches',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Wedding Wear & Accessories',
						],
						'slug'             => 'wedding-wear-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Beauty & Well being',
					'fr' => 'Beauté & Bien-être',
					'es' => 'Belleza y Bienestar',
					'ar' => 'الجمال والرفاهية',
					'pt' => 'Beleza e Bem estar',
					'ru' => 'Красота и благополучие',
					'tr' => 'Güzellik ve Sağlık',
					'th' => 'ความงามและความเป็นอยู่ที่ดี',
					'ka' => 'სილამაზე და კეთილდღეობა',
					'zh' => '美容与健康',
					'ja' => '美容と幸福',
					'it' => 'Bellezza e benessere',
					'ro' => 'Frumusețe și bunăstare',
					'de' => 'Schönheit & Wohlbefinden',
					'hi' => 'सौंदर्य और भलाई',
					'bn' => 'সৌন্দর্য ও সুস্থতা',
					'he' => 'יופי ורווחה',
				],
				'slug'             => 'beauty-well-being',
				'description'      => null,
				'image_path'       => 'app/categories/blue/spa.png',
				'icon_class'       => 'fa-solid fa-spa',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Bath & Body',
						],
						'slug'             => 'bath-and-body',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Fragrance',
						],
						'slug'             => 'fragrance',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Hair Beauty',
						],
						'slug'             => 'hair-beauty',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Makeup',
						],
						'slug'             => 'makeup',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Sexual Wellness',
						],
						'slug'             => 'sexual-wellness',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Skin Care',
						],
						'slug'             => 'care',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Tobacco Accessories',
						],
						'slug'             => 'tobacco-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Tools & Accessories',
						],
						'slug'             => 'tools-and-accessories',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Vitamins & Supplements',
						],
						'slug'             => 'vitamins-and-supplements',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Pro Massage',
						],
						'slug'             => 'pro-massage',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Jobs',
					'fr' => 'Emplois',
					'es' => 'Trabajos',
					'ar' => 'وظائف',
					'pt' => 'Empregos',
					'ru' => 'Вакансии',
					'tr' => 'Meslekler',
					'th' => 'งาน',
					'ka' => 'სამუშაო ადგილები',
					'zh' => '职位',
					'ja' => 'ジョブズ',
					'it' => 'Lavori',
					'ro' => 'Locuri de munca',
					'de' => 'Arbeitsplätze',
					'hi' => 'नौकरियां',
					'bn' => 'চাকরি',
					'he' => 'מקומות תעסוקה',
				],
				'slug'             => 'jobs',
				'description'      => null,
				'image_path'       => 'app/categories/blue/mfglabs-users.png',
				'icon_class'       => 'fa-solid fa-briefcase',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'job-offer',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Agriculture - Environment',
						],
						'slug'             => 'agriculture-environment',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Assistantship - Secretariat - Helpdesk',
						],
						'slug'             => 'assistantship-secretariat-helpdesk',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Automotive - Mechanic',
						],
						'slug'             => 'automotive-mechanic',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'BTP - Construction - Building',
						],
						'slug'             => 'btp-construction-building',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Trade - Business Services',
						],
						'slug'             => 'trade-business-services',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Commercial - Sale Jobs',
						],
						'slug'             => 'commercial-sale-jobs',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Accounting - Management - Finance',
						],
						'slug'             => 'accounting-management-finance',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Steering - Manager',
						],
						'slug'             => 'steering-manager',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Aesthetics - Hair - Beauty',
						],
						'slug'             => 'aesthetics-hair-beauty',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Public Service Jobs',
						],
						'slug'             => 'public-service-jobs',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Real Estate Jobs',
						],
						'slug'             => 'real-estate-jobs',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Independent - Freelance - Telecommuting',
						],
						'slug'             => 'independent-freelance-telecommuting',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Computers - Internet - Telecommunications',
						],
						'slug'             => 'computers-internet-telecommunications',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Industry, Production & engineering',
						],
						'slug'             => 'industry-production-engineering',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Marketing - Communication',
						],
						'slug'             => 'marketing-communication',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Babysitting - Nanny Work',
						],
						'slug'             => 'babysitting-nanny-work',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'HR - Training - Education',
						],
						'slug'             => 'hr-training-education',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Medical - Healthcare - Social',
						],
						'slug'             => 'medical-healthcare-social',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Security - Guarding',
						],
						'slug'             => 'security-guarding',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Household Services - Housekeeping',
						],
						'slug'             => 'household-services-housekeeping',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Tourism - Hotels - Restaurants - Leisure',
						],
						'slug'             => 'tourism-hotels-restaurants-leisure',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Transportation - Logistics',
						],
						'slug'             => 'transportation-logistics',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Others Jobs Offer',
						],
						'slug'             => 'others-jobs-offer',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'job-offer',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Services',
					'fr' => 'Services',
					'es' => 'Servicios',
					'ar' => 'خدمات',
					'pt' => 'Serviços',
					'ru' => 'Сервисы',
					'tr' => 'Hizmetler',
					'th' => 'บริการ',
					'ka' => 'მომსახურება',
					'zh' => '服务',
					'ja' => 'サービス',
					'it' => 'Servizi',
					'ro' => 'Servicii',
					'de' => 'Dienstleistungen',
					'hi' => 'सेवाएं',
					'bn' => 'সেবা',
					'he' => 'שירותים',
				],
				'slug'             => 'services',
				'description'      => null,
				'image_path'       => 'app/categories/blue/ion-clipboard.png',
				'icon_class'       => 'fa-solid fa-clipboard-list',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Casting, Model, Photographer',
						],
						'slug'             => 'casting-model-photographer',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Carpooling',
						],
						'slug'             => 'carpooling',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Moving, Furniture Guard',
						],
						'slug'             => 'moving-furniture-guard',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Destocking - Commercial',
						],
						'slug'             => 'destocking-commercial',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Industrial Equipment',
						],
						'slug'             => 'industrial-equipment',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Aesthetics, Hairstyling',
						],
						'slug'             => 'aesthetics-hairstyling',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Materials and Equipment Pro',
						],
						'slug'             => 'materials-and-equipment-pro',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Event Organization Services',
						],
						'slug'             => 'event-organization-services',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Service Provision',
						],
						'slug'             => 'service-provision',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Health, Beauty',
						],
						'slug'             => 'health-beauty',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Artisan, Troubleshooting, Handyman',
						],
						'slug'             => 'artisan-troubleshooting-handyman',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Computing Services',
						],
						'slug'             => 'computing-services',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Tourism and Travel Services',
						],
						'slug'             => 'tourism-and-travel-services',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Translation, Writing',
						],
						'slug'             => 'translation-writing',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Construction - Renovation - Carpentry',
						],
						'slug'             => 'construction-renovation-carpentry',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Other services',
						],
						'slug'             => 'other-services',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Learning',
					'fr' => 'Apprentissage',
					'es' => 'Aprendizaje',
					'ar' => 'تعلم',
					'pt' => 'Aprendendo',
					'ru' => 'Обучение',
					'tr' => 'Öğrenme',
					'th' => 'การเรียนรู้',
					'ka' => 'სწავლა',
					'zh' => '学习',
					'ja' => '学習',
					'it' => 'Apprendimento',
					'ro' => 'Învăţare',
					'de' => 'Lernen',
					'hi' => 'सीखना',
					'bn' => 'শেখা',
					'he' => 'לְמִידָה',
				],
				'slug'             => 'learning',
				'description'      => null,
				'image_path'       => 'app/categories/blue/fa-graduation-cap.png',
				'icon_class'       => 'fa-solid fa-graduation-cap',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Language Classes',
						],
						'slug'             => 'language-classes',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Computer Courses',
						],
						'slug'             => 'computer-courses',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Tutoring, Private Lessons',
						],
						'slug'             => 'tutoring-private-lessons',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Vocational Training',
						],
						'slug'             => 'vocational-training',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Maths, Physics, Chemistry',
						],
						'slug'             => 'maths-physics-chemistry',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Music, Theatre, Dance',
						],
						'slug'             => 'music-theatre-dance',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'School support',
						],
						'slug'             => 'school-support',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
			[
				'parent_id'        => null,
				'name'             => [
					'en' => 'Local Events',
					'fr' => 'Evénements',
					'es' => 'Eventos',
					'ar' => 'الأحداث',
					'pt' => 'Eventos',
					'ru' => 'События',
					'tr' => 'Etkinlikler',
					'th' => 'เหตุการณ์',
					'ka' => 'Ივენთი',
					'zh' => '当地活动',
					'ja' => 'ローカルイベント',
					'it' => 'Eventi locali',
					'ro' => 'Evenimente locale',
					'de' => 'Lokale Veranstaltungen',
					'hi' => 'स्थानीय कार्यक्रम',
					'bn' => 'স্থানীয় ঘটনা',
					'he' => 'אירועים מקומיים',
				],
				'slug'             => 'local-events',
				'description'      => null,
				'image_path'       => 'app/categories/blue/calendar-alt.png',
				'icon_class'       => 'fa-regular fa-calendar-days',
				'lft'              => '0',
				'rgt'              => '0',
				'depth'            => '0',
				'type'             => 'classified',
				'is_for_permanent' => '0',
				'active'           => '1',
				'children'         => [
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Concerts & Festivals',
						],
						'slug'             => 'concerts-and-festivals',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Networking & Meetups',
						],
						'slug'             => 'networking-and-meetups',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Sports & Outdoors',
						],
						'slug'             => 'sports-and-outdoors',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Trade Shows & Conventions',
						],
						'slug'             => 'trade-shows-conventions',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Training & Seminars',
						],
						'slug'             => 'training-and-seminars',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Ceremonies',
						],
						'slug'             => 'ceremonies',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Conferences',
						],
						'slug'             => 'conferences',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Weddings',
						],
						'slug'             => 'weddings',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Birthdays',
						],
						'slug'             => 'birthdays',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Family Events',
						],
						'slug'             => 'family-events',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'Nightlife',
						],
						'slug'             => 'nightlife',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
					[
						'parent_id'        => null,
						'name'             => [
							'en' => 'All others events',
						],
						'slug'             => 'all-others-events',
						'description'      => null,
						'image_path'       => 'app/default/categories/fa-folder-blue.png',
						'icon_class'       => null,
						'lft'              => '0',
						'rgt'              => '0',
						'depth'            => '1',
						'type'             => 'classified',
						'is_for_permanent' => '0',
						'active'           => '1',
					],
				],
			],
		];
		
		$tableName = (new Category())->getTable();
		foreach ($entries as $entry) {
			$subEntries = [];
			if (isset($entry['children'])) {
				$subEntries = $entry['children'];
				unset($entry['children']);
			}
			
			$lft = isset($rgt) ? ($rgt + 1) : 1;
			
			$entry = arrayTranslationsToJson($entry);
			$entryId = DB::table($tableName)->insertGetId($entry);
			
			DB::table($tableName)->where('id', $entryId)->update(['lft' => $lft]);
			
			if (!empty($subEntries)) {
				foreach ($subEntries as $subEntry) {
					$lft = $lft + 1;
					$rgt = $lft + 1;
					
					$subEntry = arrayTranslationsToJson($subEntry);
					$subEntryId = DB::table($tableName)->insertGetId($subEntry);
					DB::table($tableName)->where('id', $subEntryId)->update([
						'parent_id' => $entryId,
						'lft'       => $lft,
						'rgt'       => $rgt,
					]);
				}
				$rgt = isset($rgt) ? ($rgt + 1) : 2;
			} else {
				$rgt = isset($lft) ? ($lft + 1) : 2;
			}
			
			DB::table($tableName)->where('id', $entryId)->update(['rgt' => $rgt]);
		}
	}
}
