<?php

use App\Exceptions\Custom\CustomException;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// ===| DATABASE |===
try {
	
	// payments
	if (!Schema::hasColumn('payments', 'currency_code')) {
		Schema::table('payments', function (Blueprint $table) {
			$table->string('currency_code', 3)->nullable()->after('amount');
		});
	}
	
} catch (\Throwable $e) {
	
	$message = $e->getMessage() . "\n" . 'in ' . str_replace(base_path(), '', __FILE__);
	throw new CustomException($message);
	
}
